package gov.va.med.mhv.usermgmt.common.enums;

public enum MhvDownloadReportStatus {

	New("NEW", "New"),
	Processing("PROCESSING", "Processing"),
	Completed("COMPLETED", "Completed"),
	Error("ERROR", "Error");
	
	public static boolean isNew(String value) {
		return equals(New, value);
	}
	
	public static boolean isProcessing(String value) {
		return equals(Processing, value);
	}
	
	public static boolean isCompleted(String value) {
		return equals(Completed, value);
	}
	
	public static boolean isError(String value) {
		return equals(Error, value);
	}
	
	public static boolean equals(MhvDownloadReportStatus mhvDownloadReportStatus, String value) {
		return (mhvDownloadReportStatus !=  null) && (mhvDownloadReportStatus.value.equalsIgnoreCase(value)
				|| mhvDownloadReportStatus.name.equalsIgnoreCase(value));
	}
	private final String value;
	private final String name;
	
	private MhvDownloadReportStatus(String value, String name) {
		this.value = value;
		this.name = name;
	}
	
	public String getValue() {
        return value;
    }

    public String getName() {
        return name;
    }
}